///////////////////////////////////////////////////////////////////////////////
// WinHex C sample
// Copyright 2004 X_ways Software Technology AG
///////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <iostream>
using namespace std;

#include "whxapi.h"

void DumpBuf (char* buf, int count)
{
    const char HexChars[] = "0123456789abcdef";
    const int ValuesPerLine = 16;
    const int AddressChars = 4;
    int i, j;

    for (i = 0; i * ValuesPerLine < count; i++) {

        for (j = AddressChars-2; j >= 0; j--)
            cout << HexChars[(i >> (j*4)) & 15];
        cout << "0: ";

        //cout << HexChars[(i>>4) & 15] << HexChars[i & 15] << "0: ";
        for (j = 0; j < ValuesPerLine; j++) {
            if (i * ValuesPerLine + j < count) {
                unsigned char c = buf[i * ValuesPerLine + j];
                cout << HexChars[(c>>4) & 15] << HexChars[c & 15] << " ";
            } else
                cout << "   ";
        }

        for (j = 0; j < ValuesPerLine; j++) {
            if (i * ValuesPerLine + j < count) {
                unsigned char c = max (buf[i * ValuesPerLine + j], 32);
                cout << c;
            } else
                cout << " ";
        }
        cout << endl;
    }
}

///////////////////////////////////////////////////////////////////////////////

int main (int argc, char** argv)
{
   // Open a file in read-only mode (flag 0x1).
   // You can also open an image file with the contents of a disk and interpret 
   // it as such by specifying another flag (0x4).
   if (argc < 2) {
      cout << "Please give a file name" << endl;
      return 1;
   }

   // Initialize the WinHex API, so that it is ready for use
   int initRes = WHX_Init(1);
   if (initRes <= 0) {
      cout << "Could not initialize WinHexAPI.dll, error" << initRes << endl;
      WHX_Done();
      return 1;
   } else if (initRes == 2) {
      cout << "Opened WinHex API, evaluation version" << endl;
   }
   
   if (! WHX_OpenEx(argv[1], 0x00000001)) {
      cout << "Error opening " << argv[1] << endl;
      WHX_Done();
      return 1;
   }

   //WHX_Goto(SomeOffset);
   char buf[256];
   WHX_Read(buf, sizeof(buf));
   DumpBuf(buf, sizeof(buf));

   // Close the file
   WHX_Close();

   // Properly free all allocated resources and release the WinHex API
   WHX_Done();

   return 0;
}
