Attribute VB_Name = "Sample"
'{******************************************************************}
'{                                                                  }
'{       WinHex API Sample Application for Visual Basic 5 & 6       }
'{                                                                  }
'{       Copyright  2002, Alexander Asyabrik             }
'{                                                                  }
'{       Requires an existing installation of WinHex 10.1 SR-2      }
'{          (WinHex 10.45 SR-2 for SetErrorMode function)           }
'{          (WinHex 10.55 for GetCurObjName function)               }
'{       or later and a professional/specialist/API WinHex license. }
'{                                                                  }
'{       Also requires whxapi2.bas with functions declarations      }
'{                                                                  }
'{******************************************************************}

Option Explicit
Const AppName As String = "WHXAPI for VB5/VB6"

Sub Main()

Dim Res&

'   {Initialize the WinHex API}
   
   Res = WHX_Init(1&)
   If Res = 1 Then
      MsgBox "Initialization successful. Let's go.", vbInformation, AppName
      Call ApiDemonstration
   '      {Unload the WinHex API.}
      Call WHX_Done
   Else
      Select Case Res
         Case 0
            MsgBox "General Error", vbCritical
         Case -1
            MsgBox "WinHex installation not ready", vbCritical
         Case -2
            MsgBox "API version incorrect", vbCritical
         Case -3
            MsgBox "Invalid or insufficient license", vbCritical
      End Select
      MsgBox "An error occurred during initialization. Error code #" & str$(Res), vbCritical, AppName
   End If
      MsgBox "Exit", , AppName
End Sub

Sub ApiDemonstration()
   Dim Buffer() As Byte, Tmp As String, Pos As Currency
   '   {Create a new file with an initial size of 100,000 bytes (all zeroes).}
   If WHX_Create("C:\Dummy12345.dat", 100000) = 0 Then
      MsgBox "Could not create the test file.", vbCritical, AppName
   End If

'   {Fill a buffer with exclamation marks and write it into the file.
'   This concerns the first half of the file (50,000 bytes).}
'------------------------------------

' 1) Main method:
   Tmp = String(50000, "!")          ' make source string
   ReDim Buffer(50000)               ' prepare buffer size
   Call ChangeBytes(Tmp, Buffer())   ' put data from temp string to buffer
   If WHX_Write(Buffer(0), 50000) = 0 Then
      MsgBox "Could not write to the test file.", vbCritical, AppName
   End If
   
' 2) And more simple alternative:
'   tmp = String(50000, "!")          ' make source string
'   If WHX_WriteString(tmp, Len(tmp)) = 0 Then
'      MsgBox "Could not write to the test file.", vbCritical, AppName
'   End If
'
'------------------------------------

   Call WHX_CurrentPos(Pos)
   MsgBox "The current position in the file is " & Format(API2VB(Pos)), vbInformation, AppName
   
'   {Back to the start of the file.}
   Call WHX_Goto(VB2API(0))
   
'   {Move 50,0000 bytes forward again.}
   Call WHX_Move(VB2API(50000))
   
'------
'  1) {Now read 50,000 zero bytes into the byte buffer.}
   ReDim Buffer(50000)               ' prepare buffer
   Call WHX_Read(Buffer(0), 50000)
   Tmp = ChangeToStringUni(Buffer()) ' translate data to VB string

'  2) {More simple way to read data direct into VB string.}
'   tmp = String(50000, vbNullChar)  ' prepare buffer
'   Call WHX_ReadString(tmp, 50000)
'------

'   {Save the file under a slightly different name.}
   Call WHX_SaveAs("C:\Dummy12345!.dat")

'   {Close the file.}
   Call WHX_Close

'   {Open drive C:}
   If WHX_Open("C:") = 0 Then
      MsgBox "Could not open drive C:.", vbCritical, AppName
   End If

'   {Check the boot sector of drive C: for the string "FAT".}
   Call WHX_SetBlock(VB2API(0), VB2API(511))
   
   If WHX_Find("FAT", "MatchCase BlockOnly") = 0 Then
      MsgBox "Search operation failed.", vbExclamation, AppName
   End If
   
   If WHX_WasFound() Then
      MsgBox "Drive C: has a FAT file system.", vbInformation, AppName
   Else
      MsgBox "Drive C: does not have a FAT file system.", vbInformation, AppName
   End If
   
   '   { Suppress WinHex error message boxes}
   Call WHX_SetFeedbackLevel(1)
   
   '   {Now opening  nonexisting file for demo how to use Winhex error info}
   If WHX_Open("c:\blablabla.bla") = 0 Then
      Tmp = String(260, vbNullChar)       ' prepare buffer
      Call WHX_GetLastError(Tmp)
      Tmp = VBA.Left$(Tmp, InStr(1, Tmp, vbNullChar) - 1)
      
   '   {Now message in language selected by WinHex  (Cool!)}
      MsgBox Tmp, vbCritical, AppName
   End If
   
End Sub


