
{******************************************************************}
{                                                                  }
{       WinHex API Sample Application for Borland Delphi           }
{                                                                  }
{       Copyright  2001 Stefan Fleischmann                        }
{                                                                  }
{       Requires an existing installation of WinHex 10.1 SR-2      }
{       or later and a professional WinHex license.                }
{                                                                  }
{******************************************************************}

program WHXAPIApp;

uses
	Windows, WHXAPI;

const
	AppName: PChar = 'WHXAPIApp';

var
	PSt: array[0..19] of Char;

function ToPCh(C: Comp): PChar;
begin
	Str(C:0:0, PSt);
	ToPCh:=@PSt;
end;

var
	Message: TMsg;
	Pos: Comp;
	CS: array[0..255] of Char;
	Buffer: array[0..50000] of Char;

procedure APIDemonstration;
begin
	{Create a new file with an initial size of 100,000 bytes (all zeroes).}
	if WHX_Create('C:\Dummy12345.dat', 100000)=false then begin
		MessageBox(0, 'Could not create the test file.', AppName, MB_ICONHAND);
		exit;
	end;

	{Fill a buffer with exclamation marks and write it into the file.
	This concerns the first half of the file (50,000 bytes).}
	FillChar(Buffer, SizeOf(Buffer), '!');
	if WHX_Write(@Buffer, 50000)=false then begin
		MessageBox(0, 'Could not write to the test file.', AppName, MB_ICONHAND);
		exit;
	end;

	WHX_CurrentPos(@Pos);
	lStrCpy(CS, 'The current position in the file is ');
	lStrCat(CS, ToPCh(Pos));
	MessageBox(0, CS, AppName, MB_ICONINFORMATION);

	{Back to the start of the file.}
	WHX_Goto(0);
	{Move 50,0000 bytes forward again.}
	WHX_Move(50000);

	{Now read 50,000 zero bytes into the buffer.}
	WHX_Read(@Buffer, 50000);

	{Save the file under a slightly different name.}
	WHX_SaveAs('C:\Dummy12345!.dat');

	{Close the file.}
	WHX_Close;

	{Open drive C:}
	if WHX_Open('C:')=false then begin
		MessageBox(0, 'Could not open drive C:.', AppName, MB_ICONHAND);
		exit;
	end;

	{Check the boot sector of drive C: for the string "FAT".}
	WHX_SetBlock(0, 511);
	if WHX_Find('FAT', 'MatchCase BlockOnly')=false then begin
		MessageBox(0, 'Search operation failed.', AppName, MB_ICONHAND);
		exit;
	end;

	if WHX_WasFound then MessageBox(0, 'Drive C: has a FAT file system.', AppName, MB_ICONINFORMATION)
	else MessageBox(0, 'Drive C: does not have a FAT file system.', AppName, MB_ICONINFORMATION);
end;

var
	Res: Integer;

begin
	{Initialize the WinHex API}
	Res:=WHX_Init(1);
	if Res=1 then begin
		MessageBox(0, 'Initialization successful. Let''s go.', AppName, MB_ICONINFORMATION);
		APIDemonstration;

		{Unload the WinHex API.}
		WHX_Done;
	end else begin
		lStrCpy(CS, 'An error occurred during initialization. Error code #');
		lStrCat(CS, ToPCh(Res));
		MessageBox(0, CS, AppName, MB_ICONHAND);
	end;

	MessageBox(0, 'Exit', AppName, 0);
end.
