
{**************************************************************}
{                                                              }
{       WinHex API 1.1 Interface Unit for Borland Delphi       }
{                                                              }
{       Copyright  2001-2004 Stefan Fleischmann               }
{                                                              }
{       Requires an existing installation of WinHex 10.1       }
{       or later and a professional WinHex license.            }
{                                                              }
{**************************************************************}

unit whxapi;

{$ALIGN ON}

interface

uses Windows;

const
	whxapidll = 'whxapi.dll';

type
	PLONGLONG=^LONGLONG;

function WHX_Init(APIVersion: Integer): Integer; stdcall;
function WHX_Done: Boolean; stdcall;
function WHX_Open(lpResName: PChar): Boolean; stdcall;
function WHX_Create(lpPathName: PChar; Size: Integer): Boolean; stdcall;
function WHX_Close: Boolean; stdcall;
function WHX_CloseAll: Boolean; stdcall;
function WHX_NextObj: Boolean; stdcall;
function WHX_Save: Boolean; stdcall;
function WHX_SaveAs(lpNewFileName: PChar): Boolean; stdcall;
function WHX_SaveAll: Boolean; stdcall;
function WHX_OpenEx(lpResName: PChar; Param: Integer): Boolean; stdcall;

function WHX_Read(Buffer: PChar; Bytes: Integer): Boolean; stdcall;
function WHX_Write(Buffer: PChar; Bytes: Integer): Boolean; stdcall;

function WHX_GetSize(Size: PLONGLONG): Boolean; stdcall;
function WHX_Goto(Ofs: LONGLONG): Boolean; stdcall;
function WHX_Move(Distance: LONGLONG): Boolean; stdcall;
function WHX_CurrentPos(Ofs: PLONGLONG): Boolean; stdcall;
function WHX_SetBlock(Ofs1, Ofs2: LONGLONG): Boolean; stdcall;

function WHX_Copy: Boolean; stdcall;
function WHX_CopyIntoNewFile(lpNewFileName: PChar): Boolean; stdcall;
function WHX_Cut: Boolean; stdcall;
function WHX_Remove: Boolean; stdcall;
function WHX_Paste: Boolean; stdcall;
function WHX_WriteClipboard: Boolean; stdcall;

function WHX_Find(Data, lpOptions: PChar): Boolean; stdcall;
function WHX_Replace(Data1, Data2, lpOptions: PChar): Boolean; stdcall;
function WHX_WasFound: Boolean; stdcall;
function WHX_WasFoundEx: Integer; stdcall;

function WHX_Convert(Format1, Format2: PChar): Boolean; stdcall;
function WHX_Encrypt(Key: PChar; Algorithm: LongInt): Boolean; stdcall;
function WHX_Decrypt(Key: PChar; Algorithm: LongInt): Boolean; stdcall;

function WHX_GetCurObjName(lpObjName: PChar): BOOL; stdcall;
function WHX_SetFeedbackLevel(Level: LongInt): BOOL; stdcall;
function WHX_GetLastError(lpErrorMsg: PChar): BOOL; stdcall;
function WHX_SetLastError(lpErrorMsg: PChar): BOOL; stdcall;
function WHX_GetStatus(lpInstPath: PChar; lpWHXVersion, lpWHXSubVersion, lpReserved: PLongInt): BOOL; stdcall;

implementation

function WHX_Init; external whxapidll index 1;
function WHX_Done; external whxapidll index 2;
function WHX_Open; external whxapidll index 3;
function WHX_Create; external whxapidll index 4;
function WHX_Close; external whxapidll index 5;
function WHX_CloseAll; external whxapidll index 6;
function WHX_NextObj; external whxapidll index 7;
function WHX_Save; external whxapidll index 8;
function WHX_SaveAs; external whxapidll index 9;
function WHX_SaveAll; external whxapidll index 10;
function WHX_OpenEx; external whxapidll index 11;

function WHX_Read; external whxapidll index 21;
function WHX_Write; external whxapidll index 22;

function WHX_GetSize; external whxapidll index 30;
function WHX_Goto; external whxapidll index 31;
function WHX_Move; external whxapidll index 32;
function WHX_CurrentPos; external whxapidll index 33;
function WHX_SetBlock; external whxapidll index 34;

function WHX_Copy; external whxapidll index 41;
function WHX_CopyIntoNewFile; external whxapidll index 42;
function WHX_Cut; external whxapidll index 43;
function WHX_Remove; external whxapidll index 44;
function WHX_Paste; external whxapidll index 45;
function WHX_WriteClipboard; external whxapidll index 46;

function WHX_Find; external whxapidll index 51;
function WHX_Replace; external whxapidll index 52;
function WHX_WasFound; external whxapidll index 53;
function WHX_WasFoundEx; external whxapidll index 54;

function WHX_Convert; external whxapidll index 61;
function WHX_Encrypt; external whxapidll index 62;
function WHX_Decrypt; external whxapidll index 63;

function WHX_GetCurObjName; external whxapidll index 70;
function WHX_SetFeedbackLevel; external whxapidll index 71;
function WHX_GetLastError; external whxapidll index 72;
function WHX_SetLastError; external whxapidll index 73;
function WHX_GetStatus; external whxapidll index 74;

end.
