/***************************************************************
*                                                              *
*       WinHex API 1.1 module for C programming language       *
*                                                              *
*       Copyright  2001-2004 Stefan Fleischmann               *
*                                                              *
*       Requires an existing installation of WinHex 10.54      *
*       or later and a professional WinHex license.            *
*                                                              *
***************************************************************/

#include <windows.h>
#include <winbase.h>
#include "whxAPI.h"

///////////////////////////////////////////////////////////////////////////////
// Use an integer instead of a bool to indicate whether WInHex is loaded since
// the bool could contain the values 0, 1 or -1 by mistake. This is much more
// unlikely for the value used instead, although still possible

int WinHexApiLoaded = 0;
HMODULE WinHexApiDll;
const int WinHexApiLoadedCorrectValue = 0x19762004;
const int MaxErrors = 255;
const char WinHexApiDllFileName[] = "whxapi.dll";

///////////////////////////////////////////////////////////////////////////////
// Function prototypes

typedef int  (WINAPI *pdll_WHX_Init)(int APIVersion);
typedef bool (WINAPI *pdll_WHX_Done)();
typedef bool (WINAPI *pdll_WHX_Open)(LPCSTR lpResName);
typedef bool (WINAPI *pdll_WHX_Create)(LPCSTR lpPathName, int Size);
typedef bool (WINAPI *pdll_WHX_Close)();
typedef bool (WINAPI *pdll_WHX_CloseAll)();
typedef bool (WINAPI *pdll_WHX_NextObj)();
typedef bool (WINAPI *pdll_WHX_Save)();
typedef bool (WINAPI *pdll_WHX_SaveAs)(LPCSTR lpNewFileName);
typedef bool (WINAPI *pdll_WHX_SaveAll)();
typedef bool (WINAPI *pdll_WHX_OpenEx)(LPCSTR lpResName, int Param);
typedef bool (WINAPI *pdll_WHX_Read)(LPVOID lpBuffer, int Bytes);
typedef bool (WINAPI *pdll_WHX_Write)(LPVOID lpBuffer, int Bytes);
typedef bool (WINAPI *pdll_WHX_GetSize)(LPLONGLONG lpSize);
typedef bool (WINAPI *pdll_WHX_Goto)(LONGLONG Ofs);
typedef bool (WINAPI *pdll_WHX_Move)(LONGLONG Distance);
typedef bool (WINAPI *pdll_WHX_CurrentPos)(LPLONGLONG lpOfs);
typedef bool (WINAPI *pdll_WHX_SetBlock)(LONGLONG Ofs1, LONGLONG Ofs2);
typedef bool (WINAPI *pdll_WHX_Copy)();
typedef bool (WINAPI *pdll_WHX_CopyIntoNewFile)(LPCSTR lpNewFileName);
typedef bool (WINAPI *pdll_WHX_Cut)();
typedef bool (WINAPI *pdll_WHX_Remove)();
typedef bool (WINAPI *pdll_WHX_Paste)();
typedef bool (WINAPI *pdll_WHX_WriteClipboard)();
typedef bool (WINAPI *pdll_WHX_Find)(LPCSTR lpData, LPCSTR lpOptions);
typedef bool (WINAPI *pdll_WHX_Replace)(LPCSTR lpData1, LPCSTR lpData2, LPCSTR lpOptions);
typedef bool (WINAPI *pdll_WHX_WasFound)();
typedef int  (WINAPI *pdll_WHX_WasFoundEx)();
typedef bool (WINAPI *pdll_WHX_Convert)(LPCSTR lpSrcFormat, LPCSTR lpDstFormat);
typedef bool (WINAPI *pdll_WHX_Encrypt)(LPCSTR lpKey, int Algorithm);
typedef bool (WINAPI *pdll_WHX_Decrypt)(LPCSTR lpKey, int Algorithm);
typedef bool (WINAPI *pdll_WHX_GetCurObjName)(LPCSTR lpObjName);
typedef bool (WINAPI *pdll_WHX_SetFeedbackLevel)(int Level);
typedef bool (WINAPI *pdll_WHX_GetErrorMsg)(LPCSTR lpErrorMsg);
typedef bool (WINAPI *pdll_WHX_SetErrorMsg)(LPCSTR lpErrorMsg);
typedef bool (WINAPI *pdll_WHX_GetStatus)(LPCSTR lpInstPath, LPLONG lpWHXVersion,
   LPLONG lpWHXSubVersion, LPLONG lpReserved);

///////////////////////////////////////////////////////////////////////////////
// Function variables

pdll_WHX_Init dll_WHX_Init;
pdll_WHX_Done dll_WHX_Done;
pdll_WHX_Open dll_WHX_Open;
pdll_WHX_Create dll_WHX_Create;
pdll_WHX_Close dll_WHX_Close;
pdll_WHX_CloseAll dll_WHX_CloseAll;
pdll_WHX_NextObj dll_WHX_NextObj;
pdll_WHX_Save dll_WHX_Save;
pdll_WHX_SaveAs dll_WHX_SaveAs;
pdll_WHX_SaveAll dll_WHX_SaveAll;
pdll_WHX_OpenEx dll_WHX_OpenEx;
pdll_WHX_Read dll_WHX_Read;
pdll_WHX_Write dll_WHX_Write;
pdll_WHX_GetSize dll_WHX_GetSize;
pdll_WHX_Goto dll_WHX_Goto;
pdll_WHX_Move dll_WHX_Move;
pdll_WHX_CurrentPos dll_WHX_CurrentPos;
pdll_WHX_SetBlock dll_WHX_SetBlock;
pdll_WHX_Copy dll_WHX_Copy;
pdll_WHX_CopyIntoNewFile dll_WHX_CopyIntoNewFile;
pdll_WHX_Cut dll_WHX_Cut;
pdll_WHX_Remove dll_WHX_Remove;
pdll_WHX_Paste dll_WHX_Paste;
pdll_WHX_WriteClipboard dll_WHX_WriteClipboard;
pdll_WHX_Find dll_WHX_Find;
pdll_WHX_Replace dll_WHX_Replace;
pdll_WHX_WasFound dll_WHX_WasFound;
pdll_WHX_WasFoundEx dll_WHX_WasFoundEx;
pdll_WHX_Convert dll_WHX_Convert;
pdll_WHX_Encrypt dll_WHX_Encrypt;
pdll_WHX_Decrypt dll_WHX_Decrypt;
pdll_WHX_GetCurObjName dll_WHX_GetCurObjName;
pdll_WHX_SetFeedbackLevel dll_WHX_SetFeedbackLevel;
pdll_WHX_GetErrorMsg dll_WHX_GetErrorMsg;
pdll_WHX_SetErrorMsg dll_WHX_SetErrorMsg;
pdll_WHX_GetStatus dll_WHX_GetStatus;

///////////////////////////////////////////////////////////////////////////////

FARPROC GetProcAddressOrError (int index, int** errors, int& errorCount)
{
	FARPROC procAddr = GetProcAddress (WinHexApiDll, (LPCSTR) index);
	if (procAddr == NULL)
	{
		if (errorCount < MaxErrors)
		   (*errors)[errorCount] = index;
		errorCount++;
	}
	return procAddr;
}

///////////////////////////////////////////////////////////////////////////////

int __stdcall WHX_Init(int APIVersion)
{
   if (WinHexApiLoaded != WinHexApiLoadedCorrectValue) {
      // todo LoadDll, return false; if unsuccessful
      int errors[MaxErrors];
      int errorCount = 0;
      WinHexApiDll = LoadLibrary (WinHexApiDllFileName);
      if (WinHexApiDll == NULL)
         return false;

      dll_WHX_Init = reinterpret_cast<pdll_WHX_Init>(GetProcAddressOrError (1, (int**) (&errors), errorCount));
      dll_WHX_Done = reinterpret_cast<pdll_WHX_Done>(GetProcAddressOrError (2, (int**) (&errors), errorCount));
      dll_WHX_Open = reinterpret_cast<pdll_WHX_Open>(GetProcAddressOrError (3, (int**) (&errors), errorCount));
      dll_WHX_Create = reinterpret_cast<pdll_WHX_Create>(GetProcAddressOrError (4, (int**) (&errors), errorCount));
      dll_WHX_Close = reinterpret_cast<pdll_WHX_Close>(GetProcAddressOrError (5, (int**) (&errors), errorCount));
      dll_WHX_CloseAll = reinterpret_cast<pdll_WHX_CloseAll>(GetProcAddressOrError (6, (int**) (&errors), errorCount));
      dll_WHX_NextObj = reinterpret_cast<pdll_WHX_NextObj>(GetProcAddressOrError (7, (int**) (&errors), errorCount));
      dll_WHX_Save = reinterpret_cast<pdll_WHX_Save>(GetProcAddressOrError (8, (int**) (&errors), errorCount));
      dll_WHX_SaveAs = reinterpret_cast<pdll_WHX_SaveAs>(GetProcAddressOrError (9, (int**) (&errors), errorCount));
      dll_WHX_SaveAll = reinterpret_cast<pdll_WHX_SaveAll>(GetProcAddressOrError (10, (int**) (&errors), errorCount));
      dll_WHX_OpenEx = reinterpret_cast<pdll_WHX_OpenEx>(GetProcAddressOrError (11, (int**) (&errors), errorCount));
      dll_WHX_Read = reinterpret_cast<pdll_WHX_Read>(GetProcAddressOrError (21, (int**) (&errors), errorCount));
      dll_WHX_Write = reinterpret_cast<pdll_WHX_Write>(GetProcAddressOrError (22, (int**) (&errors), errorCount));
      dll_WHX_GetSize = reinterpret_cast<pdll_WHX_GetSize>(GetProcAddressOrError (30, (int**) (&errors), errorCount));
      dll_WHX_Goto = reinterpret_cast<pdll_WHX_Goto>(GetProcAddressOrError (31, (int**) (&errors), errorCount));
      dll_WHX_Move = reinterpret_cast<pdll_WHX_Move>(GetProcAddressOrError (32, (int**) (&errors), errorCount));
      dll_WHX_CurrentPos = reinterpret_cast<pdll_WHX_CurrentPos>(GetProcAddressOrError (33, (int**) (&errors), errorCount));
      dll_WHX_SetBlock = reinterpret_cast<pdll_WHX_SetBlock>(GetProcAddressOrError (34, (int**) (&errors), errorCount));
      dll_WHX_Copy = reinterpret_cast<pdll_WHX_Copy>(GetProcAddressOrError (41, (int**) (&errors), errorCount));
      dll_WHX_CopyIntoNewFile = reinterpret_cast<pdll_WHX_CopyIntoNewFile>(GetProcAddressOrError (42, (int**) (&errors), errorCount));
      dll_WHX_Cut = reinterpret_cast<pdll_WHX_Cut>(GetProcAddressOrError (43, (int**) (&errors), errorCount));
      dll_WHX_Remove = reinterpret_cast<pdll_WHX_Remove>(GetProcAddressOrError (44, (int**) (&errors), errorCount));
      dll_WHX_Paste = reinterpret_cast<pdll_WHX_Paste>(GetProcAddressOrError (45, (int**) (&errors), errorCount));
      dll_WHX_WriteClipboard = reinterpret_cast<pdll_WHX_WriteClipboard>(GetProcAddressOrError (46, (int**) (&errors), errorCount));
      dll_WHX_Find = reinterpret_cast<pdll_WHX_Find>(GetProcAddressOrError (51, (int**) (&errors), errorCount));
      dll_WHX_Replace = reinterpret_cast<pdll_WHX_Replace>(GetProcAddressOrError (52, (int**) (&errors), errorCount));
      dll_WHX_WasFound = reinterpret_cast<pdll_WHX_WasFound>(GetProcAddressOrError (53, (int**) (&errors), errorCount));
      dll_WHX_WasFoundEx = reinterpret_cast<pdll_WHX_WasFoundEx>(GetProcAddressOrError (54, (int**) (&errors), errorCount));
      dll_WHX_Convert = reinterpret_cast<pdll_WHX_Convert>(GetProcAddressOrError (61, (int**) (&errors), errorCount));
      dll_WHX_Encrypt = reinterpret_cast<pdll_WHX_Encrypt>(GetProcAddressOrError (62, (int**) (&errors), errorCount));
      dll_WHX_Decrypt = reinterpret_cast<pdll_WHX_Decrypt>(GetProcAddressOrError (63, (int**) (&errors), errorCount));
      dll_WHX_GetCurObjName = reinterpret_cast<pdll_WHX_GetCurObjName>(GetProcAddressOrError (70, (int**) (&errors), errorCount));
      dll_WHX_SetFeedbackLevel = reinterpret_cast<pdll_WHX_SetFeedbackLevel>(GetProcAddressOrError (71, (int**) (&errors), errorCount));
      dll_WHX_GetErrorMsg = reinterpret_cast<pdll_WHX_GetErrorMsg>(GetProcAddressOrError (72, (int**) (&errors), errorCount));
      dll_WHX_SetErrorMsg = reinterpret_cast<pdll_WHX_SetErrorMsg>(GetProcAddressOrError (73, (int**) (&errors), errorCount));
      dll_WHX_GetStatus = reinterpret_cast<pdll_WHX_GetStatus>(GetProcAddressOrError (74, (int**) (&errors), errorCount));

	  if (errorCount == 0) {
         int initRes = dll_WHX_Init (APIVersion);
         if (initRes > 0) {
            WinHexApiLoaded = WinHexApiLoadedCorrectValue;            
         }
         return initRes;
	  } else {
		  return -4;
	  }
   } else
      return -4;
}

bool WINAPI WHX_Done()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Done ();
   } else
      return true;
}

bool WINAPI WHX_Open(LPCSTR lpResName)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Open(lpResName);
   } else
      return false;
}

bool WINAPI WHX_Create(LPCSTR lpPathName, int Size)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Create(lpPathName, Size);
   } else
      return false;
}

bool WINAPI WHX_Close()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Close ();
   } else
      return false;
}

bool WINAPI WHX_CloseAll()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_CloseAll();
   } else
      return false;
}

bool WINAPI WHX_NextObj()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_NextObj ();
   } else
      return false;
}

bool WINAPI WHX_Save()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Save();
   } else
      return false;
}

bool WINAPI WHX_SaveAs(LPCSTR lpNewFileName)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_SaveAs (lpNewFileName);
   } else
      return false;
}

bool WINAPI WHX_SaveAll()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_SaveAll ();
   } else
      return false;
}

bool WINAPI WHX_OpenEx(LPCSTR lpResName, int Param)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_OpenEx (lpResName, Param);
   } else
      return false;
}

bool WINAPI WHX_Read(LPVOID lpBuffer, int Bytes)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Read (lpBuffer, Bytes);
   } else
      return false;
}

bool WINAPI WHX_Write(LPVOID lpBuffer, int Bytes)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Write (lpBuffer, Bytes);
   } else
      return false;
}

bool WINAPI WHX_GetSize(LPLONGLONG lpSize)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_GetSize (lpSize);
   } else
      return false;
}

bool WINAPI WHX_Goto(LONGLONG Ofs)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Goto(Ofs);
   } else
      return false;
}

bool WINAPI WHX_Move(LONGLONG Distance)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Move (Distance);
   } else
      return false;
}

bool WINAPI WHX_CurrentPos(LPLONGLONG lpOfs)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_CurrentPos (lpOfs);
   } else
      return false;
}

bool WINAPI WHX_SetBlock(LONGLONG Ofs1, LONGLONG Ofs2)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_SetBlock (Ofs1, Ofs2);
   } else
      return false;
}

bool WINAPI WHX_Copy()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Copy ();
   } else
      return false;
}

bool WINAPI WHX_CopyIntoNewFile(LPCSTR lpNewFileName)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_CopyIntoNewFile (lpNewFileName);
   } else
      return false;
}

bool WINAPI WHX_Cut()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Cut();
   } else
      return false;
}

bool WINAPI WHX_Remove()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Remove();
   } else
      return false;
}

bool WINAPI WHX_Paste()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Paste ();
   } else
      return false;
}

bool WINAPI WHX_WriteClipboard()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_WriteClipboard ();
   } else
      return false;
}

bool WINAPI WHX_Find(LPCSTR lpData, LPCSTR lpOptions)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Find (lpData, lpOptions);
   } else
      return false;
}


bool WINAPI WHX_Replace(LPCSTR lpData1, LPCSTR lpData2, LPCSTR lpOptions)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Replace (lpData1, lpData2, lpOptions);
   } else
      return false;
}

bool WINAPI WHX_WasFound()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_WasFound ();
   } else
      return false;
}

int WINAPI WHX_WasFoundEx()
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_WasFoundEx ();
   } else
      return false;
}

bool WINAPI WHX_Convert(LPCSTR lpSrcFormat, LPCSTR lpDstFormat)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Convert (lpSrcFormat, lpDstFormat);
   } else
      return false;
}

bool WINAPI WHX_Encrypt(LPCSTR lpKey, int Algorithm)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Encrypt(lpKey, Algorithm);
   } else
      return false;
}

bool WINAPI WHX_Decrypt(LPCSTR lpKey, int Algorithm)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_Decrypt(lpKey, Algorithm);
   } else
      return false;
}

bool WINAPI WHX_GetCurObjName(LPCSTR lpObjName)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_GetCurObjName(lpObjName);
   } else
      return false;
}

bool WINAPI WHX_SetFeedbackLevel(int Level)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_SetFeedbackLevel(Level);
   } else
      return false;
}

bool WINAPI WHX_GetErrorMsg(LPCSTR lpErrorMsg)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_GetErrorMsg(lpErrorMsg);
   } else
      return false;
}

bool WINAPI WHX_SetErrorMsg(LPCSTR lpErrorMsg)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_SetErrorMsg(lpErrorMsg);
   } else
      return false;
}

bool WINAPI WHX_GetStatus(LPCSTR lpInstPath, LPLONG lpWHXVersion,
   LPLONG lpWHXSubVersion, LPLONG lpReserved)
{
   if (WinHexApiLoaded == WinHexApiLoadedCorrectValue) {
      return dll_WHX_GetStatus(lpInstPath, lpWHXVersion,
                               lpWHXSubVersion, lpReserved);
   } else
      return false;
}
