/***************************************************************
*                                                              *
*       WinHex API 1.1 module for C programming language       *
*                                                              *
*       Copyright  2001-2004 Stefan Fleischmann               *
*                                                              *
*       Requires an existing installation of WinHex 10.54      *
*       or later and a professional WinHex license.            *
*                                                              *
***************************************************************/

extern "C" {

#ifndef LPLONGLONG
#define LPLONGLONG LONGLONG*
#endif

int __stdcall WHX_Init(
   int APIVersion = 1
);

bool WINAPI WHX_Done(
);

bool WINAPI WHX_Open(
   LPCSTR lpResName
);

bool WINAPI WHX_Create(
   LPCSTR lpPathName,
   int Size
);

bool WINAPI WHX_Close(
);

bool WINAPI WHX_CloseAll(
);

bool WINAPI WHX_NextObj(
);

bool WINAPI WHX_Save(
);

bool WINAPI WHX_SaveAs(
   LPCSTR lpNewFileName
);

bool WINAPI WHX_SaveAll(
);

bool WINAPI WHX_OpenEx(
   LPCSTR lpResName,
   int Param
);

bool WINAPI WHX_Read(
   LPVOID lpBuffer,
   int Bytes
);

bool WINAPI WHX_Write(
   LPVOID lpBuffer,
   int Bytes
);

bool WINAPI WHX_GetSize(
   LPLONGLONG lpSize
);

bool WINAPI WHX_Goto(
   LONGLONG Ofs
);

bool WINAPI WHX_Move(
   LONGLONG Distance
);

bool WINAPI WHX_CurrentPos(
   LPLONGLONG lpOfs
);

bool WINAPI WHX_SetBlock(
   LONGLONG Ofs1,
   LONGLONG Ofs2
);

bool WINAPI WHX_Copy(
);

bool WINAPI WHX_CopyIntoNewFile(
   LPCSTR lpNewFileName
);

bool WINAPI WHX_Cut(
);

bool WINAPI WHX_Remove(
);

bool WINAPI WHX_Paste(
);

bool WINAPI WHX_WriteClipboard(
);

bool WINAPI WHX_Find(
   LPCSTR lpData,
   LPCSTR lpOptions
);

bool WINAPI WHX_Replace(
   LPCSTR lpData1,
   LPCSTR lpData2,
   LPCSTR lpOptions
);

bool WINAPI WHX_WasFound(
);

int WINAPI WHX_WasFoundEx(
);

bool WINAPI WHX_Convert(
   LPCSTR lpSrcFormat,
   LPCSTR lpDstFormat
);

bool WINAPI WHX_Encrypt(
   LPCSTR lpKey,
   int Algorithm
);

bool WINAPI WHX_Decrypt(
   LPCSTR lpKey,
   int Algorithm
);

bool WINAPI WHX_GetCurObjName(
   LPCSTR lpObjName
);

bool WINAPI WHX_SetFeedbackLevel(
   int Level
);

bool WINAPI WHX_GetErrorMsg(
   LPCSTR lpErrorMsg
);

bool WINAPI WHX_SetErrorMsg(
   LPCSTR lpErrorMsg
);

bool WINAPI WHX_GetStatus(
   LPCSTR lpInstPath,
   LPLONG lpWHXVersion,
   LPLONG lpWHXSubVersion,
   LPLONG lpReserved
);

}